/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.core;

import com.nosiphus.furniture.fluid.BaseFluidType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.SoundAction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModFluidTypes {
    public static final ResourceLocation WATER_STILL = new ResourceLocation("block/water_still");
    public static final ResourceLocation WATER_FLOW = new ResourceLocation("block/water_flow");
    public static final ResourceLocation SOAP_OVERLAY = new ResourceLocation("nfm", "block/soapy_water");
    public static final ResourceLocation SOAP_RENDER_OVERLAY = new ResourceLocation("nfm", "textures/misc/soapy_water.png");
    public static final ResourceLocation SUPER_SOAP_OVERLAY = new ResourceLocation("nfm", "block/super_soapy_water");
    public static final ResourceLocation SUPER_SOAP_RENDER_OVERLAY = new ResourceLocation("nfm", "textures/misc/super_soapy_water.png");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"nfm");
    public static final RegistryObject<FluidType> SOAPY_WATER_FLUID_TYPE = ModFluidTypes.registerSoap("soapy_water", FluidType.Properties.create().lightLevel(2).density(15).viscosity(7).sound(SoundAction.get((String)"drink"), SoundEvents.f_11970_));
    public static final RegistryObject<FluidType> SUPER_SOAPY_WATER_FLUID_TYPE = ModFluidTypes.registerSuperSoap("super_soapy_water", FluidType.Properties.create().lightLevel(2).density(15).viscosity(9).sound(SoundAction.get((String)"drink"), SoundEvents.f_11970_));

    private static RegistryObject<FluidType> registerSoap(String name, FluidType.Properties properties) {
        return FLUID_TYPES.register(name, () -> new BaseFluidType(WATER_STILL, WATER_FLOW, SOAP_OVERLAY, SOAP_RENDER_OVERLAY, -1591762689, new Vec3(0.12156862765550613, (double)0.627451f, 1.0), properties));
    }

    private static RegistryObject<FluidType> registerSuperSoap(String name, FluidType.Properties properties) {
        return FLUID_TYPES.register(name, () -> new BaseFluidType(WATER_STILL, WATER_FLOW, SUPER_SOAP_OVERLAY, SUPER_SOAP_RENDER_OVERLAY, -1580859617, new Vec3(0.772549033164978, 1.0, 0.12156862765550613), properties));
    }

    public static void register(IEventBus eventBus) {
        FLUID_TYPES.register(eventBus);
    }
}

