/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import com.nosiphus.furniture.block.ShowerBottomBlock;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;

public class ShowerTopBlock
extends FurnitureHorizontalBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;
    private final Supplier<RegistryObject<Block>> bottom;

    public ShowerTopBlock(BlockBehaviour.Properties properties, Supplier<RegistryObject<Block>> bottom) {
        super(properties);
        this.bottom = bottom;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] FRONT_LEFT_FRAME = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), (Direction)Direction.EAST));
        VoxelShape[] LEFT_GLASS = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)15.0, (double)0.6), (Direction)Direction.EAST));
        VoxelShape[] BACK_LEFT_FRAME = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), (Direction)Direction.EAST));
        VoxelShape[] BACK_GLASS = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)15.5, (double)0.0, (double)0.5, (double)15.6, (double)15.0, (double)15.5), (Direction)Direction.EAST));
        VoxelShape[] BACK_RIGHT_FRAME = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), (Direction)Direction.EAST));
        VoxelShape[] RIGHT_GLASS = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.5, (double)0.0, (double)15.5, (double)15.5, (double)15.0, (double)15.6), (Direction)Direction.EAST));
        VoxelShape[] FRONT_RIGHT_FRAME = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), (Direction)Direction.EAST));
        VoxelShape[] FRONT_SUPPORT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0), (Direction)Direction.EAST));
        VoxelShape[] LEFT_SUPPORT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), (Direction)Direction.EAST));
        VoxelShape[] RIGHT_SUPPORT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), (Direction)Direction.EAST));
        VoxelShape[] BACK_SUPPORT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)15.0, (double)15.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), (Direction)Direction.EAST));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(FRONT_LEFT_FRAME[direction.m_122416_()]);
            shapes.add(LEFT_GLASS[direction.m_122416_()]);
            shapes.add(BACK_LEFT_FRAME[direction.m_122416_()]);
            shapes.add(BACK_GLASS[direction.m_122416_()]);
            shapes.add(BACK_RIGHT_FRAME[direction.m_122416_()]);
            shapes.add(RIGHT_GLASS[direction.m_122416_()]);
            shapes.add(FRONT_RIGHT_FRAME[direction.m_122416_()]);
            shapes.add(FRONT_SUPPORT[direction.m_122416_()]);
            shapes.add(LEFT_SUPPORT[direction.m_122416_()]);
            shapes.add(RIGHT_SUPPORT[direction.m_122416_()]);
            shapes.add(BACK_SUPPORT[direction.m_122416_()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState belowState = level.m_8055_(pos.m_7495_());
        if (belowState.m_60734_() instanceof ShowerBottomBlock) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, pos.m_7495_(), Block.m_49956_((BlockState)belowState));
        }
        super.m_5707_(level, pos, state, player);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }
}

