/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OvenRangeHoodBlock
extends FurnitureHorizontalBlock {
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public OvenRangeHoodBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] MAIN_HOOD = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)0.4, (double)0.0, (double)16.0, (double)3.2, (double)16.0), (Direction)Direction.EAST));
        VoxelShape[] CEILING_SUPPORT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)8.0, (double)4.0, (double)3.2, (double)16.0, (double)16.0, (double)12.8), (Direction)Direction.EAST));
        VoxelShape[] CEILING_VENT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)3.2, (double)16.0, (double)16.0, (double)12.8), (Direction)Direction.EAST));
        VoxelShape[] MAIN_HOOD_OVERLAY = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)3.2, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (Direction)Direction.EAST));
        VoxelShape[] FAR_LEFT_LIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.6, (double)0.0, (double)2.0, (double)7.0, (double)0.8, (double)3.0), (Direction)Direction.EAST));
        VoxelShape[] LEFT_LIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.6, (double)0.0, (double)4.0, (double)7.0, (double)0.8, (double)5.0), (Direction)Direction.EAST));
        VoxelShape[] CENTER_LEFT_LIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.6, (double)0.0, (double)6.0, (double)7.0, (double)0.8, (double)7.0), (Direction)Direction.EAST));
        VoxelShape[] CENTER_RIGHT_LIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.6, (double)0.0, (double)9.0, (double)7.0, (double)0.8, (double)10.0), (Direction)Direction.EAST));
        VoxelShape[] RIGHT_LIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.6, (double)0.0, (double)11.0, (double)7.0, (double)0.8, (double)13.0), (Direction)Direction.EAST));
        VoxelShape[] FAR_RIGHT_LIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.6, (double)0.0, (double)13.0, (double)7.0, (double)0.8, (double)14.0), (Direction)Direction.EAST));
        VoxelShape[] BACK_LIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)9.0, (double)0.0, (double)1.6, (double)14.4, (double)0.8, (double)14.4), (Direction)Direction.EAST));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            boolean down = (Boolean)state.m_61143_((Property)DOWN);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            if (!down) {
                shapes.add(MAIN_HOOD[direction.m_122416_()]);
                shapes.add(CEILING_SUPPORT[direction.m_122416_()]);
                shapes.add(MAIN_HOOD_OVERLAY[direction.m_122416_()]);
                shapes.add(FAR_LEFT_LIGHT[direction.m_122416_()]);
                shapes.add(LEFT_LIGHT[direction.m_122416_()]);
                shapes.add(CENTER_LEFT_LIGHT[direction.m_122416_()]);
                shapes.add(CENTER_RIGHT_LIGHT[direction.m_122416_()]);
                shapes.add(RIGHT_LIGHT[direction.m_122416_()]);
                shapes.add(FAR_RIGHT_LIGHT[direction.m_122416_()]);
                shapes.add(BACK_LIGHT[direction.m_122416_()]);
            } else if (down) {
                shapes.add(CEILING_VENT[direction.m_122416_()]);
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        boolean down = level.m_8055_(pos.m_7495_()).m_60734_() == this;
        return (BlockState)state.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{DOWN});
        builder.m_61104_(new Property[]{LIT});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
        }
        return InteractionResult.SUCCESS;
    }
}

