/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityShader {
    public static final Capability<ShaderWrapper> SHADER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ShaderWrapper>(){});
    public static ModelProperty<ShaderCase> MODEL_PROPERTY = new ModelProperty();

    public static class ShaderWrapper_Direct
    extends ShaderWrapper
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        @Nonnull
        protected ItemStack shader = ItemStack.f_41583_;
        private LazyOptional<ShaderWrapper> opt = CapabilityUtils.constantOptional(this);

        public ShaderWrapper_Direct(ResourceLocation type) {
            super(type);
        }

        @Override
        public void setShaderItem(@Nonnull ItemStack shader) {
            this.shader = shader;
        }

        @Override
        @Nonnull
        public ItemStack getShaderItem() {
            return this.shader;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == SHADER_CAPABILITY) {
                return this.opt.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            ItemStack shader = this.getShaderItem();
            if (!shader.m_41619_()) {
                shader.m_41739_(nbt);
            } else {
                nbt.m_128359_("IE:NoShader", "");
            }
            nbt.m_128359_("IE:ShaderType", this.getShaderType().toString());
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.setShaderType(new ResourceLocation(nbt.m_128461_("IE:ShaderType")));
            if (!nbt.m_128441_("IE:NoShader")) {
                this.setShaderItem(ItemStack.m_41712_((CompoundTag)nbt));
            }
        }
    }

    public static class ShaderWrapper_Item
    extends ShaderWrapper {
        public static final String SHADER_NBT_KEY = "IE:Shader";
        protected final ItemStack container;

        public ShaderWrapper_Item(ResourceLocation type, ItemStack container) {
            super(type);
            this.container = container;
        }

        @Override
        public void setShaderItem(ItemStack shader) {
            if (!this.container.m_41782_()) {
                this.container.m_41751_(new CompoundTag());
            }
            if (!shader.m_41619_()) {
                CompoundTag shaderTag = shader.m_41739_(new CompoundTag());
                this.container.m_41784_().m_128365_(SHADER_NBT_KEY, (Tag)shaderTag);
            } else {
                this.container.m_41784_().m_128473_(SHADER_NBT_KEY);
            }
        }

        @Override
        @Nonnull
        public ItemStack getShaderItem() {
            if (!this.container.m_41782_()) {
                return ItemStack.f_41583_;
            }
            CompoundTag tagCompound = this.container.m_41784_();
            if (!tagCompound.m_128425_(SHADER_NBT_KEY, 10)) {
                return ItemStack.f_41583_;
            }
            return ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_(SHADER_NBT_KEY));
        }
    }

    public static abstract class ShaderWrapper {
        protected ResourceLocation shaderType;

        public ShaderWrapper(ResourceLocation type) {
            this.shaderType = type;
        }

        public void setShaderType(ResourceLocation shaderType) {
            this.shaderType = shaderType;
        }

        public ResourceLocation getShaderType() {
            return this.shaderType;
        }

        public abstract void setShaderItem(@Nonnull ItemStack var1);

        @Nonnull
        public abstract ItemStack getShaderItem();

        public ShaderCase getCase() {
            ItemStack shaderStack = this.getShaderItem();
            Item item = shaderStack.m_41720_();
            if (item instanceof IShaderItem) {
                IShaderItem shaderItem = (IShaderItem)item;
                return shaderItem.getShaderCase(shaderStack, this.getShaderType());
            }
            return null;
        }
    }
}

