/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.symmetryWand.mirror;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.equipment.symmetryWand.mirror.CrossPlaneMirror;
import com.simibubi.create.content.equipment.symmetryWand.mirror.EmptyMirror;
import com.simibubi.create.content.equipment.symmetryWand.mirror.PlaneMirror;
import com.simibubi.create.content.equipment.symmetryWand.mirror.TriplePlaneMirror;
import com.simibubi.create.foundation.utility.Lang;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class SymmetryMirror {
    public static final String EMPTY = "empty";
    public static final String PLANE = "plane";
    public static final String CROSS_PLANE = "cross_plane";
    public static final String TRIPLE_PLANE = "triple_plane";
    protected Vec3 position;
    protected StringRepresentable orientation;
    protected int orientationIndex;
    public boolean enable;
    private static final String $ORIENTATION = "direction";
    private static final String $POSITION = "pos";
    private static final String $TYPE = "type";
    private static final String $ENABLE = "enable";

    public SymmetryMirror(Vec3 pos) {
        this.position = pos;
        this.enable = true;
        this.orientationIndex = 0;
    }

    public static List<Component> getMirrors() {
        return ImmutableList.of((Object)Lang.translateDirect("symmetry.mirror.plane", new Object[0]), (Object)Lang.translateDirect("symmetry.mirror.doublePlane", new Object[0]), (Object)Lang.translateDirect("symmetry.mirror.triplePlane", new Object[0]));
    }

    public StringRepresentable getOrientation() {
        return this.orientation;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public int getOrientationIndex() {
        return this.orientationIndex;
    }

    public void rotate(boolean forward) {
        this.orientationIndex += forward ? 1 : -1;
        this.setOrientation();
    }

    public void process(Map<BlockPos, BlockState> blocks) {
        HashMap<BlockPos, BlockState> result = new HashMap<BlockPos, BlockState>();
        for (BlockPos pos : blocks.keySet()) {
            result.putAll(this.process(pos, blocks.get(pos)));
        }
        blocks.putAll(result);
    }

    public abstract Map<BlockPos, BlockState> process(BlockPos var1, BlockState var2);

    protected abstract void setOrientation();

    public abstract void setOrientation(int var1);

    public abstract String typeName();

    @OnlyIn(value=Dist.CLIENT)
    public abstract PartialModel getModel();

    public void applyModelTransform(PoseStack ms) {
    }

    public CompoundTag writeToNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_($ORIENTATION, this.orientationIndex);
        ListTag floatList = new ListTag();
        floatList.add((Object)FloatTag.m_128566_((float)((float)this.position.f_82479_)));
        floatList.add((Object)FloatTag.m_128566_((float)((float)this.position.f_82480_)));
        floatList.add((Object)FloatTag.m_128566_((float)((float)this.position.f_82481_)));
        nbt.m_128365_($POSITION, (Tag)floatList);
        nbt.m_128359_($TYPE, this.typeName());
        nbt.m_128379_($ENABLE, this.enable);
        return nbt;
    }

    public static SymmetryMirror fromNBT(CompoundTag nbt) {
        ListTag floatList = nbt.m_128437_($POSITION, 5);
        Vec3 pos = new Vec3((double)floatList.m_128775_(0), (double)floatList.m_128775_(1), (double)floatList.m_128775_(2));
        SymmetryMirror element = switch (nbt.m_128461_($TYPE)) {
            case PLANE -> new PlaneMirror(pos);
            case CROSS_PLANE -> new CrossPlaneMirror(pos);
            case TRIPLE_PLANE -> new TriplePlaneMirror(pos);
            default -> new EmptyMirror(pos);
        };
        element.setOrientation(nbt.m_128451_($ORIENTATION));
        element.enable = nbt.m_128471_($ENABLE);
        return element;
    }

    protected Vec3 getDiff(BlockPos position) {
        return this.position.m_82490_(-1.0).m_82520_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
    }

    protected BlockPos getIDiff(BlockPos position) {
        Vec3 diff = this.getDiff(position);
        return new BlockPos((int)diff.f_82479_, (int)diff.f_82480_, (int)diff.f_82481_);
    }

    protected BlockState flipX(BlockState in) {
        return in.m_60715_(Mirror.FRONT_BACK);
    }

    protected BlockState flipY(BlockState in) {
        for (Property property : in.m_61147_()) {
            if (property == BlockStateProperties.f_61402_) {
                return (BlockState)in.m_61122_(property);
            }
            if (!(property instanceof DirectionProperty)) continue;
            if (in.m_61143_(property) == Direction.DOWN) {
                return (BlockState)in.m_61124_((Property)((DirectionProperty)property), (Comparable)Direction.UP);
            }
            if (in.m_61143_(property) != Direction.UP) continue;
            return (BlockState)in.m_61124_((Property)((DirectionProperty)property), (Comparable)Direction.DOWN);
        }
        return in;
    }

    protected BlockState flipZ(BlockState in) {
        return in.m_60715_(Mirror.LEFT_RIGHT);
    }

    protected BlockState flipD1(BlockState in) {
        return in.m_60717_(Rotation.COUNTERCLOCKWISE_90).m_60715_(Mirror.FRONT_BACK);
    }

    protected BlockState flipD2(BlockState in) {
        return in.m_60717_(Rotation.COUNTERCLOCKWISE_90).m_60715_(Mirror.LEFT_RIGHT);
    }

    protected BlockPos flipX(BlockPos position) {
        BlockPos diff = this.getIDiff(position);
        return new BlockPos(position.m_123341_() - 2 * diff.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    protected BlockPos flipY(BlockPos position) {
        BlockPos diff = this.getIDiff(position);
        return new BlockPos(position.m_123341_(), position.m_123342_() - 2 * diff.m_123342_(), position.m_123343_());
    }

    protected BlockPos flipZ(BlockPos position) {
        BlockPos diff = this.getIDiff(position);
        return new BlockPos(position.m_123341_(), position.m_123342_(), position.m_123343_() - 2 * diff.m_123343_());
    }

    protected BlockPos flipD2(BlockPos position) {
        BlockPos diff = this.getIDiff(position);
        return new BlockPos(position.m_123341_() - diff.m_123341_() + diff.m_123343_(), position.m_123342_(), position.m_123343_() - diff.m_123343_() + diff.m_123341_());
    }

    protected BlockPos flipD1(BlockPos position) {
        BlockPos diff = this.getIDiff(position);
        return new BlockPos(position.m_123341_() - diff.m_123341_() - diff.m_123343_(), position.m_123342_(), position.m_123343_() - diff.m_123343_() - diff.m_123341_());
    }

    public void setPosition(Vec3 pos3d) {
        this.position = pos3d;
    }

    public abstract List<Component> getAlignToolTips();
}

