/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.blockentity;

import com.nosiphus.furniture.client.menu.OvenMenu;
import com.nosiphus.furniture.core.ModBlockEntities;
import com.nosiphus.furniture.recipe.CookingRecipe;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OvenBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(10){

        protected void onContentsChanged(int slot) {
            OvenBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> OvenBlockEntity.this.progress1;
                case 1 -> OvenBlockEntity.this.progress2;
                case 2 -> OvenBlockEntity.this.progress3;
                case 3 -> OvenBlockEntity.this.progress4;
                case 4 -> OvenBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    OvenBlockEntity.this.progress1 = value;
                    break;
                }
                case 1: {
                    OvenBlockEntity.this.progress2 = value;
                    break;
                }
                case 2: {
                    OvenBlockEntity.this.progress3 = value;
                    break;
                }
                case 3: {
                    OvenBlockEntity.this.progress4 = value;
                    break;
                }
                case 4: {
                    OvenBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 5;
        }
    };
    private int progress1 = 0;
    private int progress2 = 0;
    private int progress3 = 0;
    private int progress4 = 0;
    private int maxProgress = 100;

    public OvenBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.OVEN.get(), pos, state);
    }

    public int getContainerSize() {
        return 10;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.nfm.oven");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new OvenMenu(id, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("oven.progress1", this.progress1);
        tag.m_128405_("oven.progress2", this.progress2);
        tag.m_128405_("oven.progress3", this.progress3);
        tag.m_128405_("oven.progress4", this.progress4);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.progress1 = tag.m_128451_("oven.progress1");
        this.progress2 = tag.m_128451_("oven.progress2");
        this.progress3 = tag.m_128451_("oven.progress3");
        this.progress4 = tag.m_128451_("oven.progress4");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, OvenBlockEntity blockEntity) {
        if (level != null) {
            if (level.m_5776_()) {
                return;
            }
            if (OvenBlockEntity.hasRecipe(blockEntity, 1, 2)) {
                ++blockEntity.progress1;
                OvenBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                if (blockEntity.progress1 >= blockEntity.maxProgress) {
                    OvenBlockEntity.craftItem(blockEntity, 1, 2);
                }
            } else {
                blockEntity.resetProgress(1);
                OvenBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            }
            if (OvenBlockEntity.hasRecipe(blockEntity, 3, 4)) {
                ++blockEntity.progress2;
                OvenBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                if (blockEntity.progress2 >= blockEntity.maxProgress) {
                    OvenBlockEntity.craftItem(blockEntity, 3, 4);
                }
            } else {
                blockEntity.resetProgress(3);
                OvenBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            }
            if (OvenBlockEntity.hasRecipe(blockEntity, 5, 6)) {
                ++blockEntity.progress3;
                OvenBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                if (blockEntity.progress3 >= blockEntity.maxProgress) {
                    OvenBlockEntity.craftItem(blockEntity, 5, 6);
                }
            } else {
                blockEntity.resetProgress(5);
                OvenBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            }
            if (OvenBlockEntity.hasRecipe(blockEntity, 7, 8)) {
                ++blockEntity.progress4;
                OvenBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                if (blockEntity.progress4 >= blockEntity.maxProgress) {
                    OvenBlockEntity.craftItem(blockEntity, 7, 8);
                }
            } else {
                blockEntity.resetProgress(7);
                OvenBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    private void resetProgress(int inputSlot) {
        if (inputSlot == 1) {
            this.progress1 = 0;
        } else if (inputSlot == 3) {
            this.progress2 = 0;
        } else if (inputSlot == 5) {
            this.progress3 = 0;
        } else if (inputSlot == 7) {
            this.progress4 = 0;
        }
    }

    private static void craftItem(OvenBlockEntity blockEntity, int inputSlot, int outputSlot) {
        Level level = blockEntity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        inventory.m_6836_(1, blockEntity.itemHandler.getStackInSlot(inputSlot));
        inventory.m_6836_(2, blockEntity.itemHandler.getStackInSlot(outputSlot));
        Optional recipe = level.m_7465_().m_44015_((RecipeType)CookingRecipe.Type.INSTANCE, (Container)inventory, level);
        if (OvenBlockEntity.hasRecipe(blockEntity, inputSlot, outputSlot)) {
            blockEntity.itemHandler.extractItem(inputSlot, 1, false);
            blockEntity.itemHandler.setStackInSlot(outputSlot, new ItemStack((ItemLike)((CookingRecipe)recipe.get()).m_8043_(null).m_41720_(), blockEntity.itemHandler.getStackInSlot(outputSlot).m_41613_() + 1));
            blockEntity.resetProgress(inputSlot);
        }
    }

    private static boolean hasRecipe(OvenBlockEntity blockEntity, int inputSlot, int outputSlot) {
        Level level = blockEntity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        inventory.m_6836_(1, blockEntity.itemHandler.getStackInSlot(inputSlot));
        inventory.m_6836_(2, blockEntity.itemHandler.getStackInSlot(outputSlot));
        boolean hasRedstoneBlockInFirstSlot = blockEntity.itemHandler.getStackInSlot(0).m_41720_() == Items.f_42153_;
        Optional recipe = level.m_7465_().m_44015_((RecipeType)CookingRecipe.Type.INSTANCE, (Container)inventory, level);
        return hasRedstoneBlockInFirstSlot && recipe.isPresent() && OvenBlockEntity.canInsertAmountIntoOutputSlot(inventory, outputSlot) && OvenBlockEntity.canInsertItemIntoOutputSlot(inventory, ((CookingRecipe)recipe.get()).m_8043_(null));
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack stack) {
        return inventory.m_8020_(2).m_41720_() == stack.m_41720_() || inventory.m_8020_(2).m_41619_();
    }

    private static boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory, int outputSlot) {
        return inventory.m_8020_(2).m_41741_() > inventory.m_8020_(2).m_41613_();
    }

    public boolean stillValid(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }
}

