/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.blockentity;

import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.util.BlockEntityUtil;
import com.mrcrayfish.furniture.util.ItemStackHelper;
import com.nosiphus.furniture.core.ModBlockEntities;
import com.nosiphus.furniture.core.ModRecipeTypes;
import com.nosiphus.furniture.core.ModSounds;
import com.nosiphus.furniture.recipe.ChoppingRecipe;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ChoppingBoardBlockEntity
extends BlockEntity {
    private ItemStack food = null;
    private final NonNullList<ItemStack> foodStack = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);

    public ChoppingBoardBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CHOPPING_BOARD.get(), pos, state);
    }

    public int getDirection(BlockState state) {
        if (state.m_61143_((Property)FurnitureHorizontalBlock.DIRECTION) == Direction.EAST) {
            return 0;
        }
        if (state.m_61143_((Property)FurnitureHorizontalBlock.DIRECTION) == Direction.SOUTH) {
            return 1;
        }
        if (state.m_61143_((Property)FurnitureHorizontalBlock.DIRECTION) == Direction.WEST) {
            return 2;
        }
        if (state.m_61143_((Property)FurnitureHorizontalBlock.DIRECTION) == Direction.NORTH) {
            return 3;
        }
        return 0;
    }

    public void setFood(ItemStack food) {
        this.food = food;
        if (food == null) {
            this.foodStack.set(0, (Object)ItemStack.f_41583_);
        } else {
            this.foodStack.set(0, (Object)food);
        }
    }

    public ItemStack getFood() {
        return this.food;
    }

    public NonNullList<ItemStack> getFoodStack() {
        return this.foodStack;
    }

    public boolean chopFood() {
        Optional<ChoppingRecipe> optional;
        if (this.food != null && (optional = this.findMatchingRecipe(this.food)).isPresent()) {
            if (!this.f_58857_.m_5776_()) {
                ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.2, (double)this.f_58858_.m_123343_() + 0.5, optional.get().m_8043_(this.f_58857_.m_9598_()).m_41777_());
                this.f_58857_.m_7967_((Entity)itemEntity);
                this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5, (SoundEvent)ModSounds.BLOCK_CHOPPING_BOARD_KNIFE_CHOP.get(), SoundSource.BLOCKS, 1.0f, 0.5f);
            }
            this.setFood(null);
            CompoundTag compoundTag = new CompoundTag();
            this.writeFood(compoundTag);
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, (CompoundTag)compoundTag);
            return true;
        }
        return false;
    }

    public Optional<ChoppingRecipe> findMatchingRecipe(ItemStack input) {
        return this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.CHOPPING.get(), (Container)new SimpleContainer(new ItemStack[]{input}), this.f_58857_);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        if (compoundTag.m_128425_("ChoppingBoard", 9)) {
            this.foodStack.clear();
            ItemStackHelper.loadAllItems((String)"ChoppingBoard", (CompoundTag)compoundTag, this.foodStack);
            this.setFood((ItemStack)this.foodStack.get(0));
        }
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        this.writeFood(compoundTag);
    }

    public CompoundTag writeFood(CompoundTag compoundTag) {
        ItemStackHelper.saveAllItems((String)"ChoppingBoard", (CompoundTag)compoundTag, this.foodStack, (boolean)true);
        return compoundTag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, this::getUpdateTag);
    }

    private CompoundTag getUpdateTag(BlockEntity blockEntity) {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compoundTag = pkt.m_131708_();
        this.m_142466_(compoundTag);
    }
}

