/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import com.nosiphus.furniture.blockentity.OvenBlockEntity;
import com.nosiphus.furniture.core.ModBlockEntities;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class OvenBlock
extends FurnitureHorizontalBlock
implements EntityBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public OvenBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] TOP_FRAME = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)13.0, (double)3.0, (double)14.0, (double)16.0, (double)13.0), (Direction)Direction.EAST));
        VoxelShape[] LEFT_FRAME = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)3.0), (Direction)Direction.EAST));
        VoxelShape[] BACK_FRAME = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)13.0, (double)1.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0), (Direction)Direction.EAST));
        VoxelShape[] RIGHT_FRAME = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)13.0, (double)14.0, (double)16.0, (double)15.0), (Direction)Direction.EAST));
        VoxelShape[] BOTTOM_FRAME = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)3.0, (double)13.0), (Direction)Direction.EAST));
        VoxelShape[] DIAL_1 = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)14.0, (double)2.0, (double)2.0, (double)15.0, (double)3.0), (Direction)Direction.EAST));
        VoxelShape[] DIAL_2 = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)14.0, (double)7.0, (double)2.0, (double)15.0, (double)8.0), (Direction)Direction.EAST));
        VoxelShape[] DIAL_3 = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)14.0, (double)9.0, (double)2.0, (double)15.0, (double)10.0), (Direction)Direction.EAST));
        VoxelShape[] DIAL_4 = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)14.0, (double)11.0, (double)2.0, (double)15.0, (double)12.0), (Direction)Direction.EAST));
        VoxelShape[] DIAL_5 = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)14.0, (double)13.0, (double)2.0, (double)15.0, (double)14.0), (Direction)Direction.EAST));
        VoxelShape[] DOOR_GLASS = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.5, (double)3.0, (double)4.0, (double)2.5, (double)11.0, (double)12.0), (Direction)Direction.EAST));
        VoxelShape[] DOOR_HANDLE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.5, (double)11.5, (double)6.0, (double)1.5, (double)12.5, (double)10.0), (Direction)Direction.EAST));
        VoxelShape[] DOOR_TOP = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)11.0, (double)2.0, (double)12.0, (double)13.0, (double)14.0), (Direction)Direction.EAST));
        VoxelShape[] DOOR_LEFT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)3.0, (double)2.0, (double)2.0, (double)11.0, (double)4.0), (Direction)Direction.EAST));
        VoxelShape[] DOOR_RIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)3.0, (double)12.0, (double)2.0, (double)11.0, (double)14.0), (Direction)Direction.EAST));
        VoxelShape[] DOOR_BOTTOM = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)2.0, (double)2.0, (double)3.0, (double)14.0), (Direction)Direction.EAST));
        VoxelShape[] TRAY_BOTTOM = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), (Direction)Direction.EAST));
        VoxelShape[] TRAY_TOP = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.0, (double)7.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), (Direction)Direction.EAST));
        VoxelShape[] BURNER_1 = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.0, (double)15.5, (double)3.0, (double)7.0, (double)16.5, (double)7.0), (Direction)Direction.EAST));
        VoxelShape[] BURNER_2 = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.0, (double)15.5, (double)9.0, (double)7.0, (double)16.5, (double)13.0), (Direction)Direction.EAST));
        VoxelShape[] BURNER_3 = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)9.0, (double)15.5, (double)9.0, (double)13.0, (double)16.5, (double)13.0), (Direction)Direction.EAST));
        VoxelShape[] BURNER_4 = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)9.0, (double)15.5, (double)3.0, (double)13.0, (double)16.5, (double)7.0), (Direction)Direction.EAST));
        VoxelShape[] BACKING = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)14.0, (double)0.0, (double)0.9, (double)16.0, (double)16.0, (double)15.0), (Direction)Direction.EAST));
        VoxelShape[] BACKING_TOP = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)14.0, (double)16.0, (double)0.9, (double)16.0, (double)18.0, (double)15.0), (Direction)Direction.EAST));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(TOP_FRAME[direction.m_122416_()]);
            shapes.add(LEFT_FRAME[direction.m_122416_()]);
            shapes.add(BACK_FRAME[direction.m_122416_()]);
            shapes.add(RIGHT_FRAME[direction.m_122416_()]);
            shapes.add(BOTTOM_FRAME[direction.m_122416_()]);
            shapes.add(DIAL_1[direction.m_122416_()]);
            shapes.add(DIAL_2[direction.m_122416_()]);
            shapes.add(DIAL_3[direction.m_122416_()]);
            shapes.add(DIAL_4[direction.m_122416_()]);
            shapes.add(DIAL_5[direction.m_122416_()]);
            shapes.add(DOOR_GLASS[direction.m_122416_()]);
            shapes.add(DOOR_HANDLE[direction.m_122416_()]);
            shapes.add(DOOR_TOP[direction.m_122416_()]);
            shapes.add(DOOR_LEFT[direction.m_122416_()]);
            shapes.add(DOOR_RIGHT[direction.m_122416_()]);
            shapes.add(DOOR_BOTTOM[direction.m_122416_()]);
            shapes.add(TRAY_BOTTOM[direction.m_122416_()]);
            shapes.add(TRAY_TOP[direction.m_122416_()]);
            shapes.add(BURNER_1[direction.m_122416_()]);
            shapes.add(BURNER_2[direction.m_122416_()]);
            shapes.add(BURNER_3[direction.m_122416_()]);
            shapes.add(BURNER_4[direction.m_122416_()]);
            shapes.add(BACKING[direction.m_122416_()]);
            shapes.add(BACKING_TOP[direction.m_122416_()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.m_60734_() != newState.m_60734_() && (blockEntity = level.m_7702_(pos)) instanceof OvenBlockEntity) {
            ((OvenBlockEntity)blockEntity).drops();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!level.m_5776_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof OvenBlockEntity) {
                OvenBlockEntity blockEntity2 = (OvenBlockEntity)blockEntity;
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)blockEntity2, (BlockPos)pos);
            } else {
                throw new IllegalStateException("Oven container provider is absent.");
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OvenBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return OvenBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.OVEN.get()), OvenBlockEntity::tick);
    }
}

