/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModernDeskBlock
extends FurnitureHorizontalBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);
    private MaterialType materialType;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public ModernDeskBlock(BlockBehaviour.Properties properties, MaterialType materialType) {
        super(properties);
        this.materialType = materialType;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)Type.SINGLE)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] DESK_TOP = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (Direction)Direction.SOUTH));
        VoxelShape[] DESK_BACK = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)1.0, (double)16.0, (double)14.0, (double)3.0), (Direction)Direction.SOUTH));
        VoxelShape[] DESK_LEFT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] DESK_RIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)15.0), (Direction)Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            Type type = (Type)((Object)state.m_61143_(TYPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(DESK_TOP[direction.m_122416_()]);
            shapes.add(DESK_BACK[direction.m_122416_()]);
            switch (type) {
                case SINGLE: {
                    shapes.add(DESK_LEFT[direction.m_122416_()]);
                    shapes.add(DESK_RIGHT[direction.m_122416_()]);
                    break;
                }
                case LEFT: {
                    shapes.add(DESK_LEFT[direction.m_122416_()]);
                    break;
                }
                case RIGHT: {
                    shapes.add(DESK_RIGHT[direction.m_122416_()]);
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        Direction dir = (Direction)state.m_61143_((Property)DIRECTION);
        boolean left = this.isDesk(level, pos, dir.m_122428_(), dir);
        boolean right = this.isDesk(level, pos, dir.m_122427_(), dir);
        if (left && right) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.MIDDLE));
        }
        if (left) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.RIGHT));
        }
        if (right) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.LEFT));
        }
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.SINGLE));
    }

    private boolean isDesk(LevelAccessor level, BlockPos source, Direction checkDirection, Direction tableDirection) {
        BlockState state = level.m_8055_(source.m_121945_(checkDirection));
        return state.m_60734_() instanceof ModernDeskBlock && ((ModernDeskBlock)state.m_60734_()).materialType == this.materialType && state.m_61143_((Property)DIRECTION) == tableDirection;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE});
    }

    public static enum MaterialType {
        WHITE_CONCRETE,
        ORANGE_CONCRETE,
        MAGENTA_CONCRETE,
        LIGHT_BLUE_CONCRETE,
        YELLOW_CONCRETE,
        LIME_CONCRETE,
        PINK_CONCRETE,
        GRAY_CONCRETE,
        LIGHT_GRAY_CONCRETE,
        CYAN_CONCRETE,
        PURPLE_CONCRETE,
        BLUE_CONCRETE,
        BROWN_CONCRETE,
        GREEN_CONCRETE,
        RED_CONCRETE,
        BLACK_CONCRETE;

    }

    public static enum Type implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle");

        private final String id;

        private Type(String id) {
            this.id = id;
        }

        public String m_7912_() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }
    }
}

