/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import com.nosiphus.furniture.blockentity.MicrowaveBlockEntity;
import com.nosiphus.furniture.core.ModBlockEntities;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class MicrowaveBlock
extends FurnitureHorizontalBlock
implements EntityBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public MicrowaveBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] TOP_SIDE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)4.0, (double)7.0, (double)2.0, (double)13.0, (double)8.0, (double)12.0), (Direction)Direction.EAST));
        VoxelShape[] LEFT_SIDE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)1.0, (double)13.0, (double)8.0, (double)2.0), (Direction)Direction.EAST));
        VoxelShape[] BACK_SIDE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)13.0, (double)8.0, (double)12.0), (Direction)Direction.EAST));
        VoxelShape[] RIGHT_SIDE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)12.0, (double)13.0, (double)8.0, (double)15.0), (Direction)Direction.EAST));
        VoxelShape[] BOTTOM_SIDE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)13.0, (double)1.0, (double)12.0), (Direction)Direction.EAST));
        VoxelShape[] TOP_FRAME = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.0, (double)6.0, (double)2.0, (double)4.0, (double)7.0, (double)11.0), (Direction)Direction.EAST));
        VoxelShape[] LEFT_FRAME = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)2.0, (double)4.0, (double)6.0, (double)3.0), (Direction)Direction.EAST));
        VoxelShape[] RIGHT_FRAME = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)10.0, (double)4.0, (double)6.0, (double)11.0), (Direction)Direction.EAST));
        VoxelShape[] BOTTOM_FRAME = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.0, (double)1.0, (double)2.0, (double)4.0, (double)2.0, (double)11.0), (Direction)Direction.EAST));
        VoxelShape[] TOP_COVER = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.0, (double)7.0, (double)1.0, (double)4.0, (double)8.0, (double)12.0), (Direction)Direction.EAST));
        VoxelShape[] LEFT_COVER = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.0, (double)1.0, (double)1.0, (double)4.0, (double)7.0, (double)2.0), (Direction)Direction.EAST));
        VoxelShape[] RIGHT_COVER = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.0, (double)1.0, (double)11.0, (double)4.0, (double)7.0, (double)12.0), (Direction)Direction.EAST));
        VoxelShape[] BOTTOM_COVER = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)4.0, (double)1.0, (double)12.0), (Direction)Direction.EAST));
        VoxelShape[] CONTROLS = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)12.5, (double)4.0, (double)8.0, (double)15.0), (Direction)Direction.EAST));
        VoxelShape[] GLASS = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.5, (double)2.0, (double)3.0, (double)3.6, (double)6.0, (double)10.0), (Direction)Direction.EAST));
        VoxelShape[] PLATE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)4.25, (double)1.0, (double)3.0, (double)10.0, (double)2.0, (double)10.25), (Direction)Direction.EAST));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(TOP_SIDE[direction.m_122416_()]);
            shapes.add(LEFT_SIDE[direction.m_122416_()]);
            shapes.add(BACK_SIDE[direction.m_122416_()]);
            shapes.add(RIGHT_SIDE[direction.m_122416_()]);
            shapes.add(BOTTOM_SIDE[direction.m_122416_()]);
            shapes.add(TOP_FRAME[direction.m_122416_()]);
            shapes.add(LEFT_FRAME[direction.m_122416_()]);
            shapes.add(RIGHT_FRAME[direction.m_122416_()]);
            shapes.add(BOTTOM_FRAME[direction.m_122416_()]);
            shapes.add(TOP_COVER[direction.m_122416_()]);
            shapes.add(LEFT_COVER[direction.m_122416_()]);
            shapes.add(RIGHT_COVER[direction.m_122416_()]);
            shapes.add(BOTTOM_COVER[direction.m_122416_()]);
            shapes.add(CONTROLS[direction.m_122416_()]);
            shapes.add(GLASS[direction.m_122416_()]);
            shapes.add(PLATE[direction.m_122416_()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.m_60734_() != newState.m_60734_() && (blockEntity = level.m_7702_(pos)) instanceof MicrowaveBlockEntity) {
            ((MicrowaveBlockEntity)blockEntity).drops();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!level.m_5776_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof MicrowaveBlockEntity) {
                MicrowaveBlockEntity blockEntity2 = (MicrowaveBlockEntity)blockEntity;
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)blockEntity2, (BlockPos)pos);
            } else {
                throw new IllegalStateException("Microwave container provider is absent.");
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MicrowaveBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return MicrowaveBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.MICROWAVE.get()), MicrowaveBlockEntity::tick);
    }
}

