/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.client.menu;

import com.nosiphus.furniture.blockentity.OvenBlockEntity;
import com.nosiphus.furniture.core.ModMenuTypes;
import com.nosiphus.furniture.inventory.RedstoneSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class OvenMenu
extends AbstractContainerMenu {
    protected final OvenBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;

    public OvenMenu(int id, Inventory inventory, FriendlyByteBuf extraData) {
        this(id, inventory, inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(10));
    }

    public OvenMenu(int id, Inventory inventory, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.OVEN.get(), id);
        int i;
        OvenMenu.m_38869_((Container)inventory, (int)10);
        this.blockEntity = (OvenBlockEntity)entity;
        this.level = inventory.f_35978_.m_9236_();
        this.data = data;
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            this.m_38897_((Slot)new RedstoneSlot((IItemHandler)iItemHandler, 0, 34, 106));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 1, 53, 31));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 2, 53, 73));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 3, 71, 31));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 4, 71, 73));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 5, 89, 31));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 6, 89, 73));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 7, 107, 31));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 8, 107, 73));
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, j * 18 + 8, i * 18 + 146));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, i * 18 + 8, 204));
        }
        this.m_38884_(data);
    }

    public boolean isCooking1() {
        return this.data.m_6413_(0) > 0;
    }

    public boolean isCooking2() {
        return this.data.m_6413_(1) > 0;
    }

    public boolean isCooking3() {
        return this.data.m_6413_(2) > 0;
    }

    public boolean isCooking4() {
        return this.data.m_6413_(3) > 0;
    }

    public int getScaledProgress1() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(4);
        int progressFireSize = 14;
        return progress * progressFireSize / maxProgress;
    }

    public int getScaledProgress2() {
        int progress = this.data.m_6413_(1);
        int maxProgress = this.data.m_6413_(4);
        int progressFireSize = 14;
        return progress * progressFireSize / maxProgress;
    }

    public int getScaledProgress3() {
        int progress = this.data.m_6413_(2);
        int maxProgress = this.data.m_6413_(4);
        int progressFireSize = 14;
        return progress * progressFireSize / maxProgress;
    }

    public int getScaledProgress4() {
        int progress = this.data.m_6413_(3);
        int maxProgress = this.data.m_6413_(4);
        int progressFireSize = 14;
        return progress * progressFireSize / maxProgress;
    }

    public ItemStack m_7648_(Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < this.blockEntity.getContainerSize() ? !this.m_38903_(slotStack, this.blockEntity.getContainerSize(), this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.blockEntity.getContainerSize(), false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity.stillValid(player);
    }
}

