/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.client.menu;

import com.nosiphus.furniture.blockentity.MicrowaveBlockEntity;
import com.nosiphus.furniture.core.ModMenuTypes;
import com.nosiphus.furniture.inventory.MicrowaveSlot;
import com.nosiphus.furniture.inventory.RedstoneSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class MicrowaveMenu
extends AbstractContainerMenu {
    protected final MicrowaveBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;

    public MicrowaveMenu(int id, Inventory inventory, FriendlyByteBuf extraData) {
        this(id, inventory, inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(2));
    }

    public MicrowaveMenu(int id, Inventory inventory, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.MICROWAVE.get(), id);
        int i;
        MicrowaveMenu.m_38869_((Container)inventory, (int)2);
        this.blockEntity = (MicrowaveBlockEntity)entity;
        this.level = inventory.f_35978_.m_9236_();
        this.data = data;
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            this.m_38897_((Slot)new RedstoneSlot((IItemHandler)iItemHandler, 0, 126, 40));
            this.m_38897_((Slot)new MicrowaveSlot((IItemHandler)iItemHandler, 1, 65, 43));
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, j * 18 + 8, i * 18 + 92));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, i * 18 + 8, 150));
        }
        this.m_38884_(data);
    }

    public boolean isCooking() {
        return this.data.m_6413_(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        int progressBarSize = 27;
        return maxProgress != 0 && progress != 0 ? progress * progressBarSize / maxProgress : 0;
    }

    public ItemStack m_7648_(Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < this.blockEntity.getContainerSize() ? !this.m_38903_(slotStack, this.blockEntity.getContainerSize(), this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.blockEntity.getContainerSize(), false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity.stillValid(player);
    }
}

