/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.blockentity;

import com.nosiphus.furniture.client.menu.MicrowaveMenu;
import com.nosiphus.furniture.core.ModBlockEntities;
import com.nosiphus.furniture.recipe.CookingRecipe;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MicrowaveBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            MicrowaveBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> MicrowaveBlockEntity.this.progress;
                case 1 -> MicrowaveBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    MicrowaveBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    MicrowaveBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 100;

    public MicrowaveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MICROWAVE.get(), pos, state);
    }

    public int getContainerSize() {
        return 2;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.nfm.microwave");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new MicrowaveMenu(id, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("microwave.progress", this.progress);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.progress = tag.m_128451_("microwave.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MicrowaveBlockEntity blockEntity) {
        if (level != null) {
            if (level.m_5776_()) {
                return;
            }
            if (MicrowaveBlockEntity.hasRecipe(blockEntity)) {
                ++blockEntity.progress;
                MicrowaveBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    MicrowaveBlockEntity.craftItem(blockEntity);
                }
            } else {
                blockEntity.resetProgress();
                MicrowaveBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static void craftItem(MicrowaveBlockEntity blockEntity) {
        Level level = blockEntity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, blockEntity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = level.m_7465_().m_44015_((RecipeType)CookingRecipe.Type.INSTANCE, (Container)inventory, level);
        if (MicrowaveBlockEntity.hasRecipe(blockEntity)) {
            blockEntity.itemHandler.extractItem(1, 1, false);
            blockEntity.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)((CookingRecipe)recipe.get()).m_8043_(null).m_41720_(), blockEntity.itemHandler.getStackInSlot(1).m_41613_() + 1));
            blockEntity.resetProgress();
        }
    }

    private static boolean hasRecipe(MicrowaveBlockEntity blockEntity) {
        Level level = blockEntity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, blockEntity.itemHandler.getStackInSlot(i));
        }
        boolean hasRedstoneBlockInFirstSlot = blockEntity.itemHandler.getStackInSlot(0).m_41720_() == Items.f_42153_;
        Optional recipe = level.m_7465_().m_44015_((RecipeType)CookingRecipe.Type.INSTANCE, (Container)inventory, level);
        return hasRedstoneBlockInFirstSlot && recipe.isPresent();
    }

    public boolean stillValid(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }
}

