/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WashingMachineBlock
extends FurnitureHorizontalBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public WashingMachineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] LEFT_SIDE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0), (Direction)Direction.EAST));
        VoxelShape[] RIGHT_SIDE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0), (Direction)Direction.EAST));
        VoxelShape[] TOP = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)13.0, (double)3.0, (double)15.0, (double)16.0, (double)13.0), (Direction)Direction.EAST));
        VoxelShape[] BOTTOM = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)15.0, (double)3.0, (double)13.0), (Direction)Direction.EAST));
        VoxelShape[] BACK = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)14.0, (double)0.0, (double)3.0, (double)15.0, (double)13.0, (double)13.0), (Direction)Direction.EAST));
        VoxelShape[] DOOR_BOTTOM = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)3.0, (double)3.0, (double)2.0, (double)5.0, (double)13.0), (Direction)Direction.EAST));
        VoxelShape[] DOOR_TOP = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)11.0, (double)3.0, (double)2.0, (double)13.0, (double)13.0), (Direction)Direction.EAST));
        VoxelShape[] DOOR_LEFT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)5.0, (double)3.0, (double)2.0, (double)11.0, (double)5.0), (Direction)Direction.EAST));
        VoxelShape[] DOOR_RIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)5.0, (double)10.96, (double)2.0, (double)11.0, (double)13.0), (Direction)Direction.EAST));
        VoxelShape[] HANDLE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)11.5, (double)1.0, (double)10.0, (double)12.5), (Direction)Direction.EAST));
        VoxelShape[] GLASS = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.5, (double)5.0, (double)5.0, (double)1.6, (double)11.0, (double)11.0), (Direction)Direction.EAST));
        VoxelShape[] LEFT_BUTTON = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)14.0, (double)2.0, (double)2.0, (double)15.0, (double)3.0), (Direction)Direction.EAST));
        VoxelShape[] MIDDLE_BUTTON = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)14.0, (double)11.0, (double)2.0, (double)15.0, (double)12.0), (Direction)Direction.EAST));
        VoxelShape[] RIGHT_BUTTON = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)14.0, (double)13.0, (double)2.0, (double)15.0, (double)14.0), (Direction)Direction.EAST));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(LEFT_SIDE[direction.m_122416_()]);
            shapes.add(RIGHT_SIDE[direction.m_122416_()]);
            shapes.add(TOP[direction.m_122416_()]);
            shapes.add(BOTTOM[direction.m_122416_()]);
            shapes.add(BACK[direction.m_122416_()]);
            shapes.add(DOOR_BOTTOM[direction.m_122416_()]);
            shapes.add(DOOR_TOP[direction.m_122416_()]);
            shapes.add(DOOR_LEFT[direction.m_122416_()]);
            shapes.add(DOOR_RIGHT[direction.m_122416_()]);
            shapes.add(HANDLE[direction.m_122416_()]);
            shapes.add(GLASS[direction.m_122416_()]);
            shapes.add(LEFT_BUTTON[direction.m_122416_()]);
            shapes.add(MIDDLE_BUTTON[direction.m_122416_()]);
            shapes.add(RIGHT_BUTTON[direction.m_122416_()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
    }
}

