/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.util.BlockEntityUtil;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import com.nosiphus.furniture.blockentity.ChoppingBoardBlockEntity;
import com.nosiphus.furniture.core.ModItems;
import com.nosiphus.furniture.recipe.ChoppingRecipe;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChoppingBoardBlock
extends FurnitureHorizontalBlock
implements EntityBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public ChoppingBoardBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] CHOPPING_BOARD = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)0.5, (double)13.0, (double)1.0, (double)15.5), (Direction)Direction.EAST));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(CHOPPING_BOARD[direction.m_122416_()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack heldItem = player.m_21120_(hand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChoppingBoardBlockEntity) {
            ChoppingBoardBlockEntity choppingBoardBlockEntity = (ChoppingBoardBlockEntity)blockEntity;
            if (!heldItem.m_41619_()) {
                Optional<ChoppingRecipe> optional = choppingBoardBlockEntity.findMatchingRecipe(heldItem);
                if (optional.isPresent()) {
                    if (choppingBoardBlockEntity.getFood() == null) {
                        choppingBoardBlockEntity.setFood(new ItemStack((ItemLike)heldItem.m_41720_(), 1, heldItem.m_41783_()));
                        CompoundTag compoundTag = new CompoundTag();
                        choppingBoardBlockEntity.writeFood(compoundTag);
                        BlockEntityUtil.sendUpdatePacket((BlockEntity)choppingBoardBlockEntity, (CompoundTag)compoundTag);
                        if (!player.m_150110_().f_35937_) {
                            heldItem.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (!level.m_5776_()) {
                        ItemEntity foodEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.5, choppingBoardBlockEntity.getFood());
                        level.m_7967_((Entity)foodEntity);
                        choppingBoardBlockEntity.setFood(null);
                        CompoundTag compoundTag = new CompoundTag();
                        choppingBoardBlockEntity.writeFood(compoundTag);
                        BlockEntityUtil.sendUpdatePacket((BlockEntity)choppingBoardBlockEntity, (CompoundTag)compoundTag);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (heldItem.m_41720_() == ModItems.KNIFE.get() && choppingBoardBlockEntity.getFood() != null) {
                    if (choppingBoardBlockEntity.chopFood() && !player.m_150110_().f_35937_) {
                        heldItem.m_41721_(heldItem.m_41773_() + 1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            if (choppingBoardBlockEntity.getFood() != null) {
                if (!level.m_5776_()) {
                    ItemEntity foodEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.5, choppingBoardBlockEntity.getFood());
                    level.m_7967_((Entity)foodEntity);
                }
                choppingBoardBlockEntity.setFood(null);
                CompoundTag compoundTag = new CompoundTag();
                choppingBoardBlockEntity.writeFood(compoundTag);
                BlockEntityUtil.sendUpdatePacket((BlockEntity)choppingBoardBlockEntity, (CompoundTag)compoundTag);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ChoppingBoardBlockEntity) {
                ChoppingBoardBlockEntity blockEntity2 = (ChoppingBoardBlockEntity)blockEntity;
                Containers.m_19010_((Level)level, (BlockPos)pos, blockEntity2.getFoodStack());
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ChoppingBoardBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
    }
}

