/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.chisel;

import com.matthewperiut.chisel.Chisel;
import com.matthewperiut.chisel.block.ChiselGroupLookup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class ChiselREI
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new ChiselCategory());
        registry.addWorkstations(CategoryIdentifier.of((String)"chisel", (String)"chisel_recipes_category"), new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)Chisel.chiselSupplier.get()))});
    }

    public void registerDisplays(DisplayRegistry registry) {
        Iterator<String> chiselGroupNames = ChiselGroupLookup.getGroupNameIterator();
        while (chiselGroupNames.hasNext()) {
            registry.add((Display)new ChiselDisplay(chiselGroupNames.next()));
        }
    }

    public static class ChiselCategory
    implements DisplayCategory<ChiselDisplay> {
        private final ResourceLocation TEXTURE = new ResourceLocation("chisel", "textures/rei_recipes.png");

        public Renderer getIcon() {
            return EntryStacks.of((ItemLike)((ItemLike)Chisel.chiselSupplier.get()), (int)1);
        }

        public Component getTitle() {
            return Component.m_130674_((String)I18n.m_118938_((String)"rei.chisel.category", (Object[])new Object[0]));
        }

        public CategoryIdentifier<? extends ChiselDisplay> getCategoryIdentifier() {
            return CategoryIdentifier.of((String)"chisel", (String)"chisel_recipes_category");
        }

        public int getDisplayHeight() {
            return 200;
        }

        public int getDisplayWidth(ChiselDisplay display) {
            return 150;
        }

        public List<Widget> setupDisplay(ChiselDisplay display, Rectangle bounds) {
            ArrayList<Widget> widgets = new ArrayList<Widget>();
            Point startPoint = new Point(bounds.getMinX() + 21, bounds.getMinY() + 15);
            List<EntryIngredient> outputEntries = display.getOutputEntries();
            int j = outputEntries.size();
            int rows = (int)Math.ceil((double)j / 6.0);
            widgets.add(Widgets.createTexturedWidget((ResourceLocation)this.TEXTURE, (int)startPoint.x, (int)startPoint.y, (int)108, (int)(236 - (18 * (10 - rows) + 1))));
            ArrayList<Slot> slots = new ArrayList<Slot>();
            slots.add(Widgets.createSlot((Point)new Point(startPoint.x + 1 + 45, startPoint.y + 1 + 16)).backgroundEnabled(false).markInput().entries((Collection)display.getInputEntries().get(0)));
            for (int x = 0; x < 6; ++x) {
                for (int y = 0; y < rows && 6 * y + x < j; ++y) {
                    slots.add(Widgets.createSlot((Point)new Point(startPoint.x + 1 + 18 * x, startPoint.y + 1 + 55 + 18 * y)).markOutput().entries((Collection)outputEntries.get(6 * y + x)));
                }
            }
            widgets.addAll(slots);
            return widgets;
        }
    }

    public static class ChiselDisplay
    implements Display {
        private final List<Item> chiselGroupItems;

        public ChiselDisplay(String chiselGroup) {
            this.chiselGroupItems = ChiselGroupLookup.getBlocksInGroup(chiselGroup);
        }

        public List<EntryIngredient> getInputEntries() {
            ArrayList<EntryIngredient> entryIngredientList = new ArrayList<EntryIngredient>();
            for (Item item : this.chiselGroupItems) {
                entryIngredientList.add(EntryIngredients.of((ItemLike)item));
            }
            return entryIngredientList;
        }

        public List<EntryIngredient> getOutputEntries() {
            ArrayList<EntryIngredient> entryIngredientList = new ArrayList<EntryIngredient>();
            for (Item item : this.chiselGroupItems) {
                entryIngredientList.add(EntryIngredients.of((ItemLike)item));
            }
            return entryIngredientList;
        }

        public CategoryIdentifier<?> getCategoryIdentifier() {
            return CategoryIdentifier.of((String)"chisel", (String)"chisel_recipes_category");
        }
    }
}

