/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FakePlayerUtil {
    private static GameProfile IE_PROFILE = new GameProfile(UUID.fromString("99562b85-bd1a-4ded-bb1a-c307bf0c0133"), "[ImmersiveEngineering]");
    private static Map<LevelAccessor, FakePlayer> fakePlayerInstances = new HashMap<LevelAccessor, FakePlayer>();

    public static FakePlayer getFakePlayer(Level world) {
        return fakePlayerInstances.computeIfAbsent((LevelAccessor)world, w -> {
            if (w instanceof ServerLevel) {
                return FakePlayerFactory.get((ServerLevel)((ServerLevel)w), (GameProfile)IE_PROFILE);
            }
            return null;
        });
    }

    @SubscribeEvent
    public static void onUnload(LevelEvent.Unload ev) {
        LevelAccessor world = ev.getLevel();
        if (world instanceof ServerLevel) {
            fakePlayerInstances.remove(world);
        }
    }
}

