/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.utils.QuadTransformer;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import blusunrize.immersiveengineering.common.register.IEFluids;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.DynamicFluidContainerModel;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public final class PotionBucketModel
implements IUnbakedGeometry<PotionBucketModel> {
    private final IQuadTransformer recolorTransformer = QuadTransformer.color($ -> color);
    private final IUnbakedGeometry<?> baseGeometry;

    public PotionBucketModel(int color) {
        JsonObject baseModelJSON = new JsonObject();
        baseModelJSON.addProperty("fluid", IEFluids.POTION.getId().toString());
        this.baseGeometry = DynamicFluidContainerModel.Loader.INSTANCE.read(baseModelJSON, null);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        BakedModel baseModel = this.baseGeometry.bake(context, bakery, spriteGetter, modelTransform, overrides, modelLocation);
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(modelLocation);
        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)baseModel.getParticleIcon(ModelData.EMPTY), (ItemOverrides)new OverrideHandler(baseModel.m_7343_(), bakery, context, spriteGetter), (ItemTransforms)context.getTransforms());
        ResourceLocation fluidMaskLocation = IClientFluidTypeExtensions.of((Fluid)((Fluid)IEFluids.POTION.get())).getStillTexture();
        for (BakedModel layerModel : baseModel.getRenderPasses(ItemStack.f_41583_, false)) {
            RenderTypeGroup renderTypeGroup;
            if (layerModel instanceof SimpleBakedModel) {
                SimpleBakedModel simple = (SimpleBakedModel)layerModel;
                renderTypeGroup = ModelUtils.copyTypes(simple);
            } else {
                renderTypeGroup = RenderTypeGroup.EMPTY;
            }
            RenderTypeGroup layerGroup = renderTypeGroup;
            for (RenderType layer : layerModel.getRenderTypes(ItemStack.f_41583_, false)) {
                List baseQuads = layerModel.getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, layer);
                for (BakedQuad baseQuad : baseQuads) {
                    BakedQuad newQuad = baseQuad.m_173410_().m_245424_().m_246162_().equals((Object)fluidMaskLocation) ? this.recolorTransformer.process(baseQuad) : baseQuad;
                    builder.addQuads(layerGroup, new BakedQuad[]{newQuad});
                }
            }
        }
        return builder.build();
    }

    private static class OverrideHandler
    extends ItemOverrides {
        private final Int2ObjectMap<BakedModel> coloredModels = new Int2ObjectOpenHashMap();
        private final ItemOverrides nested;
        private final ModelBaker bakery;
        private final IGeometryBakingContext owner;
        private final Function<Material, TextureAtlasSprite> textureGetter;

        private OverrideHandler(ItemOverrides nested, ModelBaker bakery, IGeometryBakingContext owner, Function<Material, TextureAtlasSprite> textureGetter) {
            this.nested = nested;
            this.bakery = bakery;
            this.owner = owner;
            this.textureGetter = textureGetter;
        }

        @Nullable
        public BakedModel m_173464_(@Nonnull BakedModel model, @Nonnull ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity livingEntity, int unused) {
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
            if (fluid.isEmpty()) {
                return this.nested.m_173464_(model, stack, world, livingEntity, unused);
            }
            int color = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid);
            return (BakedModel)this.coloredModels.computeIfAbsent(color, i -> new PotionBucketModel(i).bake(this.owner, this.bakery, this.textureGetter, (ModelState)BlockModelRotation.X0_Y0, this, ImmersiveEngineering.rl("potion_bucket_override")));
        }
    }

    public static class Loader
    implements IGeometryLoader<PotionBucketModel> {
        public static final ResourceLocation LOADER_NAME = ImmersiveEngineering.rl("potion_bucket");

        @Nonnull
        public PotionBucketModel read(@Nonnull JsonObject modelContents, @Nonnull JsonDeserializationContext deserializationContext) {
            return new PotionBucketModel(-1);
        }
    }
}

