/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Raytracer {
    public static Set<BlockPos> rayTrace(Vec3 start, Vec3 end, Level world) {
        return Raytracer.rayTrace(start, end, world, p -> {});
    }

    public static Set<BlockPos> rayTrace(Vec3 start, Vec3 end, Level world, Consumer<BlockPos> out) {
        HashSet<BlockPos> ret = new HashSet<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        for (Direction.Axis axis : Direction.Axis.values()) {
            if (start.m_82507_(axis) > end.m_82507_(axis)) {
                Vec3 tmp = start;
                start = end;
                end = tmp;
            }
            double min = start.m_82507_(axis);
            double dif = end.m_82507_(axis) - min;
            double lengthAdd = Math.ceil(min) - start.m_82507_(axis);
            Vec3 mov = start.m_82546_(end);
            if (mov.m_82507_(axis) == 0.0) continue;
            mov = mov.m_82490_(1.0 / mov.m_82507_(axis));
            Raytracer.ray(dif, mov, start, lengthAdd, ret, world, checked, out);
        }
        if (checked.isEmpty()) {
            BlockPos pos = BlockPos.m_274446_((Position)start);
            BlockState state = world.m_8055_(pos);
            BlockHitResult rtr = state.m_60812_((BlockGetter)world, pos).m_83220_(start, end, pos);
            if (rtr != null && rtr.m_6662_() != HitResult.Type.MISS) {
                ret.add(pos);
            }
            checked.add(pos);
            out.accept(pos);
        }
        return ret;
    }

    private static void ray(double dif, Vec3 mov, Vec3 start, double lengthAdd, Set<BlockPos> ret, Level world, Set<BlockPos> checked, Consumer<BlockPos> out) {
        double standardOff = 0.0625;
        int i = 0;
        while ((double)i < dif) {
            BlockHitResult rtr;
            BlockState state;
            Vec3 pos = start.m_82549_(mov.m_82490_((double)i + lengthAdd + 0.0625));
            Vec3 posNext = start.m_82549_(mov.m_82490_((double)(i + 1) + lengthAdd + 0.0625));
            Vec3 posPrev = start.m_82549_(mov.m_82490_((double)i + lengthAdd - 0.0625));
            Vec3 posVeryPrev = start.m_82549_(mov.m_82490_((double)(i - 1) + lengthAdd - 0.0625));
            BlockPos blockPos = BlockPos.m_274446_((Position)pos);
            if (!checked.contains(blockPos) && (double)i + lengthAdd + 0.0625 < dif) {
                state = world.m_8055_(blockPos);
                rtr = state.m_60812_((BlockGetter)world, blockPos).m_83220_(pos, posNext, blockPos);
                if (rtr != null && rtr.m_6662_() != HitResult.Type.MISS) {
                    ret.add(blockPos);
                }
                checked.add(blockPos);
                out.accept(blockPos);
            }
            if (!checked.contains(blockPos = BlockPos.m_274446_((Position)posPrev)) && (double)i + lengthAdd - 0.0625 < dif) {
                state = world.m_8055_(blockPos);
                rtr = state.m_60812_((BlockGetter)world, blockPos).m_83220_(posVeryPrev, posPrev, blockPos);
                if (rtr != null && rtr.m_6662_() != HitResult.Type.MISS) {
                    ret.add(blockPos);
                }
                checked.add(blockPos);
                out.accept(blockPos);
            }
            ++i;
        }
    }
}

