/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IJEIRecipe;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;

public abstract class MultiblockRecipe
extends IESerializableRecipe
implements IMultiblockRecipe,
IJEIRecipe {
    private List<IngredientWithSize> inputList = new ArrayList<IngredientWithSize>(0);
    protected Lazy<NonNullList<ItemStack>> outputList = Lazy.of(NonNullList::m_122779_);
    protected List<FluidTagInput> fluidInputList;
    protected List<FluidStack> fluidOutputList;
    Lazy<Integer> totalProcessTime;
    Lazy<Integer> totalProcessEnergy;

    protected <T extends Recipe<?>> MultiblockRecipe(Lazy<ItemStack> outputDummy, IERecipeTypes.TypeWithClass<T> type, ResourceLocation id) {
        super(outputDummy, type, id);
    }

    public ItemStack m_8043_(RegistryAccess access) {
        NonNullList<ItemStack> outputs = this.getItemOutputs();
        if (outputs != null && outputs.size() > 0) {
            return (ItemStack)outputs.get(0);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public List<IngredientWithSize> getItemInputs() {
        return this.inputList;
    }

    protected void setInputListWithSizes(List<IngredientWithSize> inputList) {
        this.inputList = new ArrayList<IngredientWithSize>(inputList);
    }

    protected void setInputList(List<Ingredient> inputList) {
        this.inputList = inputList.stream().map(IngredientWithSize::new).collect(Collectors.toList());
    }

    @Override
    public NonNullList<ItemStack> getItemOutputs() {
        return (NonNullList)this.outputList.get();
    }

    @Override
    public List<FluidTagInput> getFluidInputs() {
        return this.fluidInputList;
    }

    @Override
    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputList;
    }

    @Override
    public int getTotalProcessTime() {
        return (Integer)this.totalProcessTime.get();
    }

    @Override
    public int getTotalProcessEnergy() {
        return (Integer)this.totalProcessEnergy.get();
    }

    void setTimeAndEnergy(int time, int energy) {
        this.totalProcessEnergy = Lazy.of(() -> energy);
        this.totalProcessTime = Lazy.of(() -> time);
    }

    public void modifyTimeAndEnergy(DoubleSupplier timeModifier, DoubleSupplier energyModifier) {
        Lazy<Integer> oldTime = this.totalProcessTime;
        Lazy<Integer> oldEnergy = this.totalProcessEnergy;
        this.totalProcessTime = Lazy.of(() -> (int)Math.max(1.0, (double)((Integer)oldTime.get()).intValue() * timeModifier.getAsDouble()));
        this.totalProcessEnergy = Lazy.of(() -> (int)Math.max(1.0, (double)((Integer)oldEnergy.get()).intValue() * energyModifier.getAsDouble()));
    }
}

