/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.plugins.impl.GroupImpl;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;

public class ClientGroup {
    private final UUID id;
    private final String name;
    private final boolean hasPassword;
    private final boolean persistent;
    private final boolean hidden;
    private final Group.Type type;

    public ClientGroup(UUID id, String name, boolean hasPassword, boolean persistent, boolean hidden, Group.Type type) {
        this.id = id;
        this.name = name;
        this.hasPassword = hasPassword;
        this.persistent = persistent;
        this.hidden = hidden;
        this.type = type;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasPassword() {
        return this.hasPassword;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Group.Type getType() {
        return this.type;
    }

    public static ClientGroup fromBytes(FriendlyByteBuf buf) {
        return new ClientGroup(buf.m_130259_(), buf.m_130136_(512), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), GroupImpl.TypeImpl.fromInt(buf.readShort()));
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.id);
        buf.m_130072_(this.name, 512);
        buf.writeBoolean(this.hasPassword);
        buf.writeBoolean(this.persistent);
        buf.writeBoolean(this.hidden);
        buf.writeShort((int)GroupImpl.TypeImpl.toInt(this.type));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientGroup group = (ClientGroup)o;
        return Objects.equals(this.id, group.id);
    }
}

