/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CookingRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;

    public CookingRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (level.m_5776_()) {
            return false;
        }
        return ((Ingredient)this.recipeItems.get(0)).test(container.m_8020_(1));
    }

    public ItemStack assemble(SimpleContainer simpleContainer, RegistryAccess registryAccess) {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public static class Serializer
    implements RecipeSerializer<CookingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("nfm", "cooking");

        public CookingRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)serializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new CookingRecipe(recipeId, output, (NonNullList<Ingredient>)inputs);
        }

        @Nullable
        public CookingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf friendlyByteBuf) {
            NonNullList inputs = NonNullList.m_122780_((int)friendlyByteBuf.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf));
            }
            ItemStack output = friendlyByteBuf.m_130267_();
            return new CookingRecipe(recipeId, output, (NonNullList<Ingredient>)inputs);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, CookingRecipe cookingRecipe) {
            friendlyByteBuf.writeInt(cookingRecipe.m_7527_().size());
            for (Ingredient ingredient : cookingRecipe.m_7527_()) {
                ingredient.m_43923_(friendlyByteBuf);
            }
            friendlyByteBuf.writeItemStack(cookingRecipe.m_8043_(null), false);
        }
    }

    public static class Type
    implements RecipeType<CookingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "cooking";

        private Type() {
        }
    }
}

